﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ProxyDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            CallWithClose();

            CallWithUsing();

            Console.ReadKey();
        }

        private static void CallWithUsing()
        {
            using (var moneyProxy = new MoneyTalkProxy())
            {
                string advice = moneyProxy.GetAdvice();

                Console.WriteLine(advice);
            }

        }

        private static string CallWithClose()
        {
            MoneyTalkProxy moneyProxy = null;
            string advice = string.Empty;

            try
            {
                moneyProxy = new MoneyTalkProxy();

                advice = moneyProxy.GetAdvice();

                Console.WriteLine(advice);
            }
            finally
            {
                moneyProxy.Close();
            }

            return advice;
        }
    }
}
